/******************************************************************************/
class StopDrawText : BaseEvent
{
public:
            StopDrawText();
   virtual ~StopDrawText();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();

   Memc<UID> m_VarStringUIDs;
   Memc<VarString*> m_VarStrings;
};
/******************************************************************************/
StopDrawText::StopDrawText() : BaseEvent()                          
{
   
}
StopDrawText::~StopDrawText()
{
   
}
/******************************************************************************/
void StopDrawText::create(Object &obj)
{
   // Getting the parameters from the object in the world
   for(int i = 1; i < 10; ++i) 
      if(Param *p = obj.findParam(S + "VarStringUID" + i)) 
         if(p.asID().valid()) m_VarStringUIDs.add(p.asID()); 

   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void StopDrawText::AfterCreate()
{
   // Find the correct VarStrings to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPAD(i, variablesString)
      REPAD (j, m_VarStringUIDs)
         if(variablesString[i].id() == m_VarStringUIDs[j])
            m_VarStrings.add(&variablesString[i]);
            
   DEBUG_ASSERT(m_VarStringUIDs.elms() == m_VarStrings.elms(), "StopDrawText: Not all text was found in the scene");
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void StopDrawText::CallTriggeredAction()
{
   REPA(m_VarStrings)
   {/*
      if(m_LogDetailed)
      {
         LogN(S+" Start Trigger: StopDrawText (INFO: " + m_EditorInfo + " ) on VarString (INFO: " + m_VarStrings[i]->m_EditorInfo + " ) ");
      }
      else if(m_LogOutput)
      {
         LogN(S+" Start Trigger: StopDrawText (INFO: " + m_EditorInfo + " )");
      }
      */
      m_VarStrings[i].SetDraw(false);
   }
}

// This method is called when the duration of the event has been reached
void StopDrawText::StopTriggeredAction()
{
   
}
/******************************************************************************/